<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Configuration;

return new class extends Migration
{
    public function up(): void
    {
        $navigationConfigs = [
            [
                'key' => 'navigation_links',
                'value' => json_encode([
                    [
                        'id' => 'home',
                        'label' => 'Home',
                        'url' => '{{ route("home") }}',
                        'route' => 'home',
                        'type' => 'link',
                        'order' => 1,
                        'active' => true,
                        'icon' => 'home'
                    ],
                    [
                        'id' => 'forum',
                        'label' => 'Forum',
                        'url' => '{{ route("forum.index") }}',
                        'route' => 'forum.*',
                        'type' => 'link',
                        'order' => 2,
                        'active' => true,
                        'icon' => 'comments'
                    ],
                    [
                        'id' => 'store',
                        'label' => 'Store',
                        'url' => '{{ route("store.index") }}',
                        'route' => 'store.*',
                        'type' => 'link',
                        'order' => 3,
                        'active' => true,
                        'icon' => 'shopping-cart',
                        'condition' => '!!config_value("store_enabled")'
                    ],
                    [
                        'id' => 'community',
                        'label' => 'Community',
                        'url' => '#',
                        'route' => 'community.*',
                        'type' => 'dropdown',
                        'order' => 4,
                        'active' => true,
                        'icon' => 'users',
                        'children' => [
                            [
                                'id' => 'users',
                                'label' => 'Users',
                                'url' => '{{ route("users.index") }}',
                                'route' => 'users.index',
                                'order' => 1,
                                'active' => true,
                                'icon' => 'user'
                            ],
                            [
                                'id' => 'map',
                                'label' => 'Interactive Map',
                                'url' => '{{ route("map") }}',
                                'route' => 'map',
                                'order' => 2,
                                'active' => true,
                                'icon' => 'map'
                            ],
                            [
                                'id' => 'news',
                                'label' => 'News',
                                'url' => '{{ route("news.index") }}',
                                'route' => 'news.index',
                                'order' => 3,
                                'active' => true,
                                'icon' => 'newspaper',
                                'condition' => '!!config_value("toggle_news")'
                            ]
                        ]
                    ]
                ]),
                'description' => 'Navigation Menu Structure',
                'type' => 'navigation',
                'group' => 'Navigation'
            ],
            [
                'key' => 'navigation_mobile_enabled',
                'value' => '1',
                'description' => 'Enable Mobile Navigation',
                'type' => 'boolean',
                'group' => 'Navigation'
            ],
            [
                'key' => 'navigation_show_icons',
                'value' => '0',
                'description' => 'Show Icons in Navigation',
                'type' => 'boolean',
                'group' => 'Navigation'
            ],
            [
                'key' => 'navigation_dropdown_style',
                'value' => 'hover',
                'description' => 'Dropdown Trigger Style',
                'type' => 'select',
                'group' => 'Navigation',
                'options' => 'hover,click'
            ]
        ];

        /*foreach ($navigationConfigs as $config) {
            Configuration::firstOrCreate(
                ['key' => $config['key']],
                $config
            );
        }
        */
    }
    
    public function down(): void
    {
        Configuration::whereIn('key', [
            'navigation_links',
            'navigation_mobile_enabled',
            'navigation_show_icons',
            'navigation_dropdown_style'
        ])->delete();
    }
};